'use strict';

/* --------------------------------------------------------------
 content_manager_overview_controller.js 2016-08-25
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

gx.compatibility.module('content_manager_overview_controller', [jse.source + '/vendor/datatables/jquery.dataTables.min.css', jse.source + '/vendor/datatables/jquery.dataTables.min.js', 'datatable'], function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES DEFINITION
    // ------------------------------------------------------------------------

    var
    /**
     * Module Selector
     *
     * @type {object}
     */
    $this = $(this),


    /**
     * Default Options
     *
     * @type {object}
     */
    defaults = {
        filterColumnIndex: 0,
        filterRegexPrefix: '^'
    },


    /**
     * Final Options
     *
     * @type {object}
     */
    options = $.extend(true, {}, defaults, data),


    /**
     * Module Object
     *
     * @type {object}
     */
    module = {};

    // ------------------------------------------------------------------------
    // FUNCTIONS
    // ------------------------------------------------------------------------

    var _createTopBar = function _createTopBar($table) {
        var $grid = $('<div class="grid" />');

        var $search = $('<div class="span4 quick-search" />'); // Input searching  

        $search.append('<form class="control-group remove-padding">' + '<label for="search-keyword">' + jse.core.lang.translate('search', 'admin_labels') + '</label>' + '<input type="text" class="search-keyword" />' + '</form>');

        var $filter = $('<div class="span8 filter" />'); // Alphabetical filtering 
        var alphabet = [];

        $table.DataTable().data().each(function (row) {
            var letter = $(row[options.filterColumnIndex]).text().trim().substring(0, 1).toUpperCase();

            if (alphabet.indexOf(letter) === -1 && letter !== '') {
                alphabet.push(letter);
            }
        });

        alphabet.sort().forEach(function (letter) {
            $filter.append('<button class="btn btn-small">' + letter + '</button>');
        });

        $grid.append([$search, $filter]);

        $table.parent().prepend($grid);
    };

    var _createBottomBar = function _createBottomBar($table) {
        var $paginator = $('<div class="paginator grid" />');
        var $datatableComponents = $('<div class="span8 datatable-components remove-padding" />');

        var $pageLength = $('<select class="page-length" />');
        $pageLength.append(new Option('20 ' + jse.core.lang.translate('PER_PAGE', 'admin_general'), 20, true, true)).append(new Option('30 ' + jse.core.lang.translate('PER_PAGE', 'admin_general')), 30).append(new Option('50 ' + jse.core.lang.translate('PER_PAGE', 'admin_general')), 50).append(new Option('100 ' + jse.core.lang.translate('PER_PAGE', 'admin_general')), 100).css('float', 'left').appendTo($datatableComponents);

        $table.siblings('.dataTables_info').appendTo($datatableComponents).css('clear', 'none');

        $table.siblings('.dataTables_paginate').appendTo($datatableComponents).css('clear', 'none');

        $paginator.append('<div class="span4">&nbsp;</div>').append($datatableComponents);

        $table.parent().append($paginator);
    };

    var _onQuickSearchSubmit = function _onQuickSearchSubmit(event) {
        event.preventDefault();

        var $table = $(this).parent().siblings('table.content_manager');
        var keyword = $(this).find('.search-keyword').val();

        $table.DataTable().search(keyword, true, false).draw();
    };

    var _onFilterButtonClick = function _onFilterButtonClick() {
        var $table = $(this).parents().eq(1).siblings('table.content_manager');

        if ($(this).hasClass('btn-primary')) {
            $(this).removeClass('btn-primary');
            $table.DataTable().column(options.filterColumnIndex).search('').draw();
            return;
        }

        $(this).siblings('.btn-primary').removeClass('btn-primary');
        $(this).addClass('btn-primary');

        var regex = options.filterRegexPrefix + $(this).text() + '.*$';
        $table.DataTable().column(options.filterColumnIndex).search(regex, true, false).draw();
    };

    var _onPageLengthChange = function _onPageLengthChange() {
        var $table = $(this).parents('.paginator').siblings('table.content_manager');
        $table.DataTable().page.len($(this).val()).draw();
    };

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        var $tables = $this.find('table.content_manager');

        // Combine ".paginator" with the DataTable HTML output in order to create a unique pagination
        // frame at the bottom of the table (executed after table initialization).
        $tables.on('init.dt', function (event, settings, json) {
            var $table = $(this);
            _createTopBar($table);
            _createBottomBar($table);
        });

        jse.libs.datatable.create($tables, {
            autoWidth: false,
            dom: 'rtip',
            pageLength: 20,
            language: jse.libs.datatable.getTranslations(jse.core.config.get('languageCode')),
            createdRow: function createdRow(row, data, dataIndex) {
                $(row).find('td').each(function () {
                    $(this).html($(this).html().trim().replace(/(\r\n|\n|\r)/gm, ''));
                });
            }
        });

        $this.on('submit', '.quick-search', _onQuickSearchSubmit).on('click', '.filter .btn', _onFilterButtonClick).on('change', '.page-length', _onPageLengthChange);

        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
